﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

//	Summary
//		* Player의 체력 관리한다.
//		* 최대 체력값, 현재 체력값 설정시 UI의 Slider/Text 를 조정한다.

namespace Game
{
	/*
		Player Health
 	*/
	public class PlayerHealth : MonoBehaviour
	{

		int _startingHealth	= 100;

		public int StartingHealth {
			set {
				_startingHealth	= value;
				CurrentHealth	= value;
				healthSlider.value	= value;
				healthSlider.maxValue	= value;
			}

			get {
				return _startingHealth;
			}
		}

		public int CurrentHealth;
		public Slider healthSlider;
		public Text healthText;
		public Image damageImage;
		public float flashSpeed	= 5f;
		public Color flashColor	= new Color (1f, 0f, 0f, 0.1f);

		Animator animator;

		bool damaged;

		void Start ()
		{
			// StartingHealth	= 100;
		}

		// Update is called once per frame
		void Update ()
		{
			if (damaged) {
				damageImage.color	= flashColor;
			} else {
				damageImage.color	= Color.Lerp (damageImage.color, Color.clear, flashSpeed * Time.deltaTime);
			}

			damaged	= false;

			healthText.text	= CurrentHealth + " / " + StartingHealth;
		}

		// MARK: - Public
		/*
			현재의 체력을 설정한다.

			@param health 현재의 체력
	 	*/
		public void setCurrentHealth (int health)
		{
			if (health < 0) {
				health	= 0;
			}

			if (health > StartingHealth) {
				health	= StartingHealth;
			}

			CurrentHealth = health;
			healthSlider.value	= health;
		}

		/*
			현재의 체력에서 값 만큼을 감소한다.

			@param amount 감소할 체력 값
	 	*/
		public void TakeDamage (int amount)
		{
			damaged	= true;

			setCurrentHealth (CurrentHealth -= amount);
		}

		/*
			현재의 체력에서 값 만큼을 증가한다.

			@param amount 증가할 체력 값
	 	*/
		public void TakeRecovery (int amount)
		{
			damaged	= false;

			setCurrentHealth (CurrentHealth += amount);
		}
	}
}
